/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xsetting.h 
 * -----------------------------------------------------------------*/

#ifndef XSETTING_H_INCLUDED
#define XSETTING_H_INCLUDED

#include <xpciapi.h>
#include <xsetutil.h>

#ifndef CLI
#define CLI
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef SWIG
/********************************************************************
  #defines **********************************************************
 *******************************************************************/

/* The depth (number of rows) of the exerciser memories */
#define BX_RIBLK_MEMDEPTH        256
#define BX_RIBEH_MEMDEPTH        256
#define BX_CTBEH_MEMDEPTH        256
#define BX_CIBEH_MEMDEPTH        256
#define BX_RTBEH_MEMDEPTH        256

/* The width (number of cols) of the exerciser memories.
   Each col represents 16 bits except block memory (32 bit) */
#define BX_RIBLK_MEMWIDTH            5     /* long based */ 
#define BX_RIBEH_MEMWIDTH           10     /* word based */ 
#define BX_CTBEH_MEMWIDTH            5     /* word based */ 
#define BX_CIBEH_MEMWIDTH            9     /* word based */ 
#define BX_RTBEH_MEMWIDTH            5     /* word based */ 

/* Number of DW's in Default (i.e. Mephisto's) Config Space */
#define BX_CTCFG_MEMDEPTH           32


/* maximum Number of DW's in Config Space */
#define BX_CTCFG_MEMDEPTHMAX           36

/* Number of lines in sequencer memory */ 
#define BX_PERFLINE_SIZE 128 /* sequencer memory size */
#define BX_TRIGLINE_SIZE 128 /* sequencer memory size */

/* Pointer to Resource Lock Counter */
#define BX_ANALYZER_RESLOCK_CTR (bx_handlearray[handle].db->Analyzer.ResLockCtrAnalyzer)
#define BX_OBSERVER_RESLOCK_CTR (bx_handlearray[handle].db->Analyzer.ResLockCtrObserver)
#define BX_PERFORMANCE_RESLOCK_CTR (bx_handlearray[handle].db->Analyzer.ResLockCtrPerformance)
#define BX_EXERCISER_RESLOCK_CTR (bx_handlearray[handle].db->Exerciser.ResLockCtrExerciser)


/********************************************************************
  Memory updating ***************************************************
 *******************************************************************/
/*
   This struct contains info about which parts of a memory
   (behavior,block) have been changed after the last card programming.
   This allows a partial memory update and thus a speedup for
   card programming.
   Do never update this struct directly, but use the 
   corresponding functions below.
*/

typedef struct 
{
  /* Touched==FALSE -> other values are undefined                     */
  /* Touched==TRUE  -> other values are in range [0,..,BX_<>_WIDTH-1] */
  bx_bool  Touched;       /* wether memory needs an update at all     */
  bx_int32 MinRow,MaxRow; /* range of rows to update (zero-based)     */
  bx_int32 MinCol,MaxCol; /* range of cols to update (zero-based)     */
} bx_memupdtype;

/* Functions for accessing the struct above (NULL-pointers always allowed) */
void EXPORT SetUpdateInfo(
  bx_memupdtype *,
  bx_bool,bx_int32,bx_int32);

void EXPORT GetUpdateInfo(
  bx_memupdtype *,
  bx_bool *,bx_int32 *,
  bx_int32 *,bx_int32 *,bx_int32 *);

/********************************************************************
  Requester-Intiator (RI) *******************************************
 *******************************************************************/

/* RI block memory */
typedef struct
{
  bx_int32      Mem[BX_RIBLK_MEMDEPTH][BX_RIBLK_MEMWIDTH];   /* memory */
  bx_memupdtype UpdateInfo;             /* Status of block memory */
} bx_dbriblktype;

/* RI behavior memory */
typedef struct
{
  bx_int16      Mem[BX_RIBEH_MEMDEPTH][BX_RIBEH_MEMWIDTH]; /* memory */
  bx_memupdtype UpdateInfo;             /* Status of behavior memory */
} bx_dbribehtype;

/* RI */
typedef struct 
{
  bx_dbriblktype    Block;
  bx_dbribehtype    Behavior;
  bx_int32          GenProp[BX_RIGENPROP_SIZE];
} bx_dbritype;

/********************************************************************
  Completer-Target (CT) *********************************************
 *******************************************************************/

/* CT behavior memory */
typedef struct
{
  bx_int16      Mem[BX_CTBEH_MEMDEPTH][BX_CTBEH_MEMWIDTH]; /* memory */
  bx_memupdtype UpdateInfo;             /* Status of behavior memory */
} bx_dbctbehtype;

/* CT configuration space */
typedef struct
{
  bx_int32 value  [BX_CTCFG_MEMDEPTHMAX];  /* Value */
  bx_int32 mask   [BX_CTCFG_MEMDEPTHMAX];  /* Mask  */
} bx_dbctcfgtype;

/* CT */
typedef struct
{
  bx_dbctbehtype  Behavior;
  bx_dbctcfgtype  ConfigSpace;    
  bx_int32        GenProp[BX_CTGENPROP_SIZE];
  bx_int32        SplitCondProp[BX_CTSPLITPROP_DEPTH][BX_CTSPLITPROP_SIZE];
  bx_int32        DecProp [BX_DECODER_SIZE][BX_DECPROP_SIZE];
} bx_dbcttype;


/********************************************************************
  Completer Initiator ***********************************************
 *******************************************************************/

/* CI behavior memory */
typedef struct
{
  bx_int16      Mem[BX_CIBEH_MEMDEPTH][BX_CIBEH_MEMWIDTH]; /* memory */
  bx_memupdtype UpdateInfo;             /* Status of behavior memory */
} bx_dbcibehtype;

/* CI */
typedef struct 
{
  bx_dbcibehtype    Behavior;
  bx_int32          GenProp[BX_CIGENPROP_SIZE];
} bx_dbcitype;

/********************************************************************
  Requester Target **************************************************
 *******************************************************************/

/* RT behavior memory */
typedef struct
{
  bx_int16      Mem[BX_RTBEH_MEMDEPTH][BX_RTBEH_MEMWIDTH]; /* memory */
  bx_memupdtype UpdateInfo;             /* Status of behavior memory */
} bx_dbrtbehtype;


/* RT */
typedef struct 
{
  bx_dbrtbehtype    Behavior;
  bx_int32          GenProp[BX_RTGENPROP_SIZE];
} bx_dbrttype;

/********************************************************************
  Exerciser *********************************************************
 *******************************************************************/

typedef struct 
{
  bx_dbritype      RequesterInitiator;
  bx_dbcttype      CompleterTarget;
  bx_dbcitype      CompleterInitiator;
  bx_dbrttype      RequesterTarget;
  bx_int32         GenProp[BX_EGENPROP_SIZE];
  bx_int32         ResLockCtrExerciser;
} bx_dbetype;

/********************************************************************
  A Performance Sequencer line **************************************
 *******************************************************************/

typedef struct 
{
  bx_int32        Transient[BX_PERFLINETRAN_SIZE];
  bx_charptrtype  Condition[BX_PERFLINECOND_SIZE];
} bx_dbperflinetype;

/********************************************************************
  A Trigger Sequencer line ******************************************
 *******************************************************************/

typedef struct 
{
  bx_int32        Transient[BX_TRIGLINETRAN_SIZE];
  bx_charptrtype  Condition[BX_TRIGLINECOND_SIZE];
} bx_dbtriglinetype;


/********************************************************************
  Performance sequencers ********************************************
 *******************************************************************/

typedef struct 
{
  bx_int32              MaxNumLines; /* 1-based */
  bx_dbperflinetype     Line[BX_PERFLINE_SIZE];
  bx_int32              GenProp[BX_PERFGEN_SIZE];  
} bx_dbperftype;

/********************************************************************
  Trigger sequencers ************************************************
 *******************************************************************/

typedef struct 
{
  bx_int32             MaxNumLines; /* 1-based */
  bx_dbtriglinetype    Line[BX_TRIGLINE_SIZE];  
  bx_int32             GenProp[BX_TRIGGEN_SIZE];  
} bx_dbtrigtype;

/********************************************************************
  Observer **********************************************************
 *******************************************************************/

typedef struct 
{
  bx_int32       Mask[BX_OBSRULEPROP_DW30];
  bx_int32       FirstErr[BX_OBSRULEPROP_DW30];
  bx_int32       AccuErr[BX_OBSRULEPROP_DW30];
} bx_dbobstype;

/********************************************************************
  Analyzer **********************************************************
 *******************************************************************/

typedef struct 
{
  bx_int32       GenProp[BX_AGENPROP_SIZE];
  bx_dbperftype  PerfSeq[BX_PERFSEQ_SIZE];
  bx_dbtrigtype  TrigSeq[BX_TRIGSEQ_SIZE];
  bx_int32       ResLockCtrAnalyzer;
  bx_int32       ResLockCtrObserver;
  bx_int32       ResLockCtrPerformance;
  bx_dbobstype   Observer;
} bx_dbatype;

/********************************************************************
  Database **********************************************************
 *******************************************************************/

/* A pointer to this struct is hold in the handle array.
   It holds information for one card. */
struct bx_dbtype
{
  bx_dbetype      Exerciser;
  bx_dbatype      Analyzer;
  bx_int32        BoardProp[BX_BOARDPROP_SIZE];
  bx_charptrtype  Pattern[BX_PATT_ENUMSIZE];
};


/********************************************************************
  Prototypes for DB  ************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXDBInit(         /* @dbinit */
  bx_handletype handle
);

#endif /* ifndef SWIG */

CLI bx_errtype EXPORT BestXAllDefaultSet(  /* @alldefset */
  bx_handletype handle
);

bx_errtype BestXDBClose(bx_handletype handle);

#ifdef __cplusplus
}
#endif

#endif
